/******************************************************************************
HPI Operating System function implementation for Linux User space

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

******************************************************************************/
#define SOURCEFILE_NAME "hpios.c"
#include <time.h>
#include "hpidebug.h"

#ifdef  __KERNEL__
#error Using userspace source for kernel build
#endif

const char *pDspCodePath = "/lib/firmware/asihpi/dsp2400.bin";

const char *HpiOs_GetDspCodePath(uint32_t nAdapter)
{
	return pDspCodePath;
}

void HpiOs_SetDspCodePath(const char *pPath)
{
	pDspCodePath = pPath;
}

void HpiOs_DelayMicroSeconds(uint32_t microsecs)
{
	struct timespec delay;

	delay.tv_sec = 0;
	delay.tv_nsec = microsecs * 1000;
	nanosleep(&delay, 0);
}

HpiOs_TIME HpiOs_QuerySystemTime(void)
{
	struct timespec tp;
	clock_gettime(CLOCK_MONOTONIC, &tp);
	return ((int64_t)tp.tv_sec * 1000000) + (tp.tv_nsec / 1000);
}

int HpiOs_SystemTimeDiffMicroseconds(HpiOs_TIME t1, HpiOs_TIME t2)
{
	return t2-t1;
}
