## deb.mk
##
##    AudioScience HPI driver
##    Copyright (C) 1997-2017  AudioScience Inc. <support@audioscience.com>
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of version 2 of the GNU General Public License as
##    published by the Free Software Foundation;
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 59 Temple Place, Suite 330,
##    Boston, MA  02111-1307  USA
##


src-deb-path-prefix = $(dist-dir-prefix)/deb
#remove-last = $(wordlist 2,$(words $(1)),x $(1))
copy-debpkg-structure = mkdir -p $(1) && rsync -r --delete $(src-deb-path-prefix)/$(notdir $(1)) $(dir $(1))
write-changelog = rm $(1)/debian/_changelog_missing && cat $(notdir $(1))-changelog.in | sed 's/-SERIES-/$(call series-from-path,$(1))/g' > $(1)/debian/changelog

debpkg-dir-names = asihpi-dkms snd-asihpi-dkms asihpi-meta python-audioscience asihpi-libs asihpi-utils

%/asihpi-dkms: $(shell find $(src-deb-path-prefix)/asihpi-dkms/) asihpi-dkms-changelog.in $(dist-dir-prefix)/hpi-drv
	$(call copy-debpkg-structure,$@)
	$(call write-changelog,$@)
	# copy source
	mkdir -p $@/src
	cp -a $(lastword $^)/* $@/src
	mv $@/src/firmware $@/firmware

%/snd-asihpi-dkms: $(shell find $(src-deb-path-prefix)/snd-asihpi-dkms/) snd-asihpi-dkms-changelog.in $(dist-dir-prefix)/alsa-drv
	$(call copy-debpkg-structure,$@)
	$(call write-changelog,$@)
	# copy source
	mkdir -p $@/src
	cp -a $(lastword $^)/* $@/src
	mv $@/src/firmware $@/firmware

%/asihpi-meta: $(shell find $(src-deb-path-prefix)/asihpi-meta/) asihpi-meta-changelog.in
	$(call copy-debpkg-structure,$@)
	$(call write-changelog,$@)

%/asihpi-libs: $(shell find $(src-deb-path-prefix)/asihpi-libs/) asihpi-libs-changelog.in $(dist-dir-prefix)/hpi-lib
	$(call copy-debpkg-structure,$@)
	$(call write-changelog,$@)
	# copy source
	mkdir -p $@/src
	cp -a $(lastword $^)/* $@/src

%/asihpi-utils: $(shell find $(src-deb-path-prefix)/asihpi-utils/) asihpi-utils-changelog.in $(dist-dir-prefix)/hpi-cli-apps
	$(call copy-debpkg-structure,$@)
	$(call write-changelog,$@)
	# copy source
	mkdir -p $@/src
	cp -a $(lastword $^)/* $@/src

%/python-audioscience: $(shell find $(src-deb-path-prefix)/python-audioscience/) python-audioscience-changelog.in $(dist-dir-prefix)/asi-python
	$(call copy-debpkg-structure,$@)
	$(call write-changelog,$@)
	# copy source
	cp -a $(lastword $^)/* $@
	# remove Makefile to avoid triggering a `make clean` which would break the package build
	rm $@/Makefile
