/*

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

*/
#ifndef _HPIFILESTORE_H_
#define  _HPIFILESTORE_H_

#include "hpi_internal.h"

#ifdef __cplusplus
/* *INDENT-OFF* */
extern "C" {
/* *INDENT-ON* */
#endif

#define HPI_SIZEOF_FLASH_FILE_HEADER_NAME 80
#define HPI_SIZEOF_FLASH_FILE_HEADER_TIMESTAMP 32
#define HPI_SIZEOF_FLASH_METADATA 32
#define HPI_FLASH_BLANK_WORD 0xffffffff
#define HPI_SIZEOF_FLASH_FILE_HEADER_SIZE 256
#define HPI_FLASH_FILE_HEADER_NOT_INUSE_BIT 1
#define HPI_FLASH_FILE_HEADER_NOT_ERASED_BIT 2
#define HPI_FLASH_FILE_HEADER_V1 0x00000001

struct  hpi_flash_file_header_v1 {
	uint32_t version_of_this_header;
	uint32_t state;
	uint32_t flags;
	uint32_t offset_in_words_to_next;
	uint32_t flash_entry_size_in_words;
	uint32_t file_size_in_bytes;
	char filename[HPI_SIZEOF_FLASH_FILE_HEADER_NAME];
	char timestamp[HPI_SIZEOF_FLASH_FILE_HEADER_TIMESTAMP];
	char metadata[HPI_SIZEOF_FLASH_METADATA];
};
compile_time_assert((sizeof(struct hpi_flash_file_header_v1) <= HPI_SIZEOF_FLASH_FILE_HEADER_SIZE), sizeof_hpi_flash_file_header_v0);

HPI_API (hpi_err_t) HPI_FileStoreOpen(
	uint16_t wAdapterIndex,
	const char *security,
	hpi_handle_t * phFileStore
);

HPI_API (hpi_err_t) HPI_FileStoreAllocDir(
	hpi_handle_t hFileStore,
	const char *name,
	char **listing
);

HPI_API (hpi_err_t) HPI_FileStoreDelete(
	hpi_handle_t hFileStore,
	const char *name
);

HPI_API (hpi_err_t) HPI_FileStoreGet(
	hpi_handle_t hFileStore,
	const char *name,
	const char *local_name
);

HPI_API (hpi_err_t) HPI_FileStorePut(
	hpi_handle_t hFileStore,
	const char *name,
	const char *file,
	const char *metadata
);

HPI_API (hpi_err_t) HPI_FileStoreDeleteAll(
	hpi_handle_t hFileStore	///< File store handle.
);

#ifdef __cplusplus
/* *INDENT-OFF* */
}
/* *INDENT-ON* */
#endif
#endif
