/******************************************************************************
Compile time checks of hpi message and response sizes.
and union members are multiple of 4 bytes

Include this file in ONLY ONE of the files in a project.

Tested to work with CCS, gcc, <add compilers here>
Doesn't work with <add compilers here>

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

******************************************************************************/

/* check that size is exactly some number */
#define compile_time_size_check(sym,size) \
    compile_time_assert(sizeof(sym)==(size),sizechk##sym)

#define compile_time_size_sucheck(tag, sym,size) \
    compile_time_assert(sizeof(tag sym)==(size),sizechk##sym)

/* check that size is a multiple of unit */
#define compile_time_unit_check(sym,unit) \
    compile_time_assert((sizeof(sym)%(unit))==0,unitchk##sym)

#define compile_time_unit_sucheck(tag, sym,unit) \
    compile_time_assert((sizeof(tag sym)%(unit))==0,unitchk##sym)

#define compile_time_struct_check(obj,msgsize,ressize) \
	compile_time_unit_sucheck(struct, obj##_msg, 4); \
	compile_time_unit_sucheck(struct, obj##_res, 4); \
    compile_time_size_sucheck(struct, obj##_msg, msgsize); \
    compile_time_size_sucheck(struct, obj##_res, ressize)

	  /* Perform the checks */
compile_time_size_check(uint8_t, 1);
compile_time_size_check(uint16_t, 2);
compile_time_size_check(uint32_t, 4);
compile_time_size_check(HPI_MESSAGE, 44);

compile_time_size_check(HPI_RESPONSE, 64);

compile_time_struct_check(hpi_subsys, 12, 16);
/* compile_time_struct_check(hpi_adapter, 8, 32); */

compile_time_unit_sucheck(union, hpi_adapterx_msg, 4);
compile_time_unit_sucheck(union, hpi_adapterx_res, 4);
compile_time_size_sucheck(union, hpi_adapterx_msg, 12);
compile_time_size_sucheck(union, hpi_adapterx_res, 32);

compile_time_struct_check(hpi_stream, 28, 24);
compile_time_struct_check(hpi_mixer, 16, 12);
compile_time_struct_check(hpi_control, 16, 12);

compile_time_unit_sucheck(struct, hpi_control_union_msg, 4);
compile_time_unit_sucheck(union, hpi_control_union_res, 4);
compile_time_size_sucheck(struct, hpi_control_union_msg, 16);
compile_time_size_sucheck(union, hpi_control_union_res, 12);

compile_time_struct_check(hpi_nvmemory, 4, 4);
compile_time_struct_check(hpi_gpio, 4, 12);
compile_time_struct_check(hpi_clock, 8, 12);
compile_time_struct_check(hpi_profile, 4, 32);
compile_time_struct_check(hpi_async, 8, 16);

compile_time_assert(HPI_CONTROL_LAST_INDEX<255,indexchkHPI_CONTROL_LAST_INDEX);

#ifndef HPI_OS_DSP_C6000
/* API HPI_FORMAT must have fixed size */
compile_time_size_check(hpi_format_t, 5 * 4);

/* Message FORMAT must fit inside API format */
compile_time_assert((sizeof(struct hpi_msg_format) <= sizeof(hpi_format_t)),
		    format_fit);
#endif

#ifdef HPI_BUILD_INCLUDE_DEPRECATED
typedef struct hpi_buffer HPI_BUFFER;

/* API HPI_FORMAT must have fixed size */
compile_time_size_sucheck(struct, hpi_data, 7 * 4);
compile_time_size_sucheck(struct, hpi_buffer, 7 * 4);
#ifndef HPI_BUILD_64BIT
#ifndef HPI_ON_DSP
compile_time_size_sucheck(struct, hpi_data_legacy32, 7 * 4);
#endif
#endif

/* Message DATA must fit inside API data */

compile_time_assert((sizeof(struct hpi_msg_data) <= sizeof(struct hpi_data)), data_fit);
#endif
