/******************************************************************************
HPI Operating System Specific macros for Linux userspace

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

(This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )
******************************************************************************/
#ifndef _HPI_OS_CONFIG_H_
#define _HPI_OS_CONFIG_H_

#undef HPI_OS_LINUX
#define HPI_OS_LINUX
#define HPI_OS_DEFINED

#ifdef  __KERNEL__
#error Using userspace header for kernel build
#endif

#include <linux/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>		/* for memset */
#include <stddef.h>
#include <sys/times.h>

#define INLINE inline

#if __GNUC__ >= 3
#define HPI_DEPRECATED __attribute__((deprecated))
#endif

#define __pack__ __attribute__ ((packed))

#define C99(x) x

#define HPI_CALLBACK

struct hpi_message;
struct hpi_response;

struct hpi_ioctl_linux {
	struct hpi_message *phm;
	struct hpi_response *phr;
};

struct hpi_os_adapter {
	int dummy;
};

#define HPI_IOCTL_LINUX _IOWR('H', 0xFC, struct hpi_ioctl_linux)

typedef FILE *HpiOs_FILE;
#define NO_FILE NULL

#define HpiOs_fopen_rb(a,b) (*(b)=fopen(a,"rb"),(*(b)?0:HPI_ERROR_DSP_FILE_NOT_FOUND))
#define HpiOs_fseek fseek
#define HpiOs_fread fread
#define HpiOs_fclose fclose

#define HpiOs_MemAlloc malloc
#define HpiOs_MemAllocZero(n) calloc(n, 1)
#define HpiOs_MemAllocZeroArray(n, a) calloc(n, a)
#define HpiOs_MemFree free

#define HPI_NO_OS_LOCKEDMEM_OPS

#ifndef HPI_BUILD_INCLUDE_ADAPTER_DEFS
#define HPI_BUILD_EXCLUDE_ADAPTER_DEFS
#endif

//#define HPIOS_DEBUG_PRINTF printf
#define HPIOS_DEBUG_PRINTF(...) fprintf(stderr, __VA_ARGS__)

// case insensitive strcmp()
#define stricmp strcasecmp

#ifndef WINELIB
static inline long GetTickCount(void)
{
	struct tms tm;
	return times(&tm);
}
#endif

//#define HIDE_DEPRECATED
//#define HPI_WITHOUT_HPI_DATA

#endif
