/******************************************************************************
 HPI NETWORK implementation

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

*******************************************************************************/

#ifndef _HPINET_H_
#define _HPINET_H_

#include "hpi_internal.h"

#ifdef __cplusplus
/* *INDENT-OFF* */
extern "C" {
/* *INDENT-ON* */
#endif

/* NOTE: sizeof(asi_pkt) is NOT 3 because it is not packed
E.g. on 64  bit linux it is 8
*/
#ifndef DISABLE_PRAGMA_PACK1
#pragma pack(push, 1)
#endif
struct asi_pkt {
	uint8_t ASIpktID;
	uint8_t ASIpktVersion;
};
#ifndef DISABLE_PRAGMA_PACK1
#pragma pack(pop)
#endif

typedef struct {
	HPI_ETHERNET_MAC_ADR destMAC;
	HPI_ETHERNET_MAC_ADR srcMAC;
	unsigned char ProtocolMS;
	unsigned char ProtocolLS;
	unsigned char ASIpktID;
	unsigned char ASIpktVersion;
} HPINET_HEADER;

typedef struct {
	unsigned char LenLS;
	unsigned char LenMS;
	unsigned char unused0;
	unsigned char unused1;
} HPINET_HEADER_SIZE_INFO;

typedef struct {
	HPINET_HEADER_SIZE_INFO size;
	HPINET_HEADER hdr;
} HPINET_HEADER_WITH_SIZE;

/** maximum payload of an ethernet packet, excluding header and CRC */
#define HPINET_ETHERNET_DATA_SIZE (1500)
#define HPINET_IP_HDR_SIZE (20)
#define HPINET_IP_DATA_SIZE (HPINET_ETHERNET_DATA_SIZE - HPINET_IP_HDR_SIZE)
#define HPINET_UDP_HDR_SIZE (8)
#define HPINET_UDP_DATA_SIZE (HPINET_IP_DATA_SIZE - HPINET_UDP_HDR_SIZE)
#define HPINET_ASI_HDR_SIZE (2)
#define HPINET_ASI_DATA_SIZE (HPINET_UDP_DATA_SIZE - HPINET_ASI_HDR_SIZE)

#define HPINET_MSG_SIZEOF_DATA (HPINET_ASI_DATA_SIZE - sizeof(HPI_MESSAGE))

typedef struct {
	HPI_MESSAGE msg;
	char data[HPINET_MSG_SIZEOF_DATA];
} HPI_MESSAGEX;

#define HPINET_RESP_SIZEOF_DATA ((HPINET_ASI_DATA_SIZE - sizeof(HPI_RESPONSE)) - 16 )
typedef struct {
	HPI_RESPONSE resp;
	char data[HPINET_RESP_SIZEOF_DATA];
} HPI_RESPONSEX;

typedef struct {
	HPINET_HEADER_WITH_SIZE hdr;
	HPI_RESPONSE HPIresp;
	char data[HPINET_RESP_SIZEOF_DATA];
} HPINET_RESP_WITH_SIZE;

#if (defined HPI_OS_WIN32_USER) || (defined HPI_OS_LINUX)
void HPI_MessageEx(HPI_MESSAGEX * phm, HPI_RESPONSEX * phr,
		   unsigned int timeout);
#endif

/* Legacy structures for hpinet.c */
typedef struct {
	HPINET_HEADER hdr;
	HPI_MESSAGE HPImsg;
	char data[HPINET_MSG_SIZEOF_DATA];
} HPINET_MSG;

typedef struct {
	HPINET_HEADER hdr;
	HPI_RESPONSE HPIresp;
	char data[HPINET_RESP_SIZEOF_DATA];
} HPINET_RESP;

#ifdef __cplusplus
/* *INDENT-OFF* */
}
/* *INDENT-ON* */
#endif
#endif
