/*****************************************************************************
Public declarations for DSP Proramming Interface to TI C6701

Shared between hpi6000.c and DSP code

    Copyright (C) 1997-2017  AudioScience Inc. <support@audioscience.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of version 2 of the GNU General Public License as
    published by the Free Software Foundation;

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/

#ifndef _HPI6000_H_
#define _HPI6000_H_

#define HPI_NMIXER_CONTROLS 200

/*
 * Control caching is always supported in the HPI code.
 * The DSP should make sure that dwControlCacheSizeInBytes is initialized to 0
 * during boot to make it in-active.
 */
struct hpi_hif_6000 {
	uint32_t dwHostCmd;
	uint32_t dwDspAck;
	uint32_t dwAddress;
	uint32_t dwLength;
	uint32_t dwMessageBufferAddress;
	uint32_t dwResponseBufferAddress;
	uint32_t dwDspNumber;
	uint32_t dwAdapterInfo;
	uint32_t dwControlCacheIsDirty;
	uint32_t dwControlCacheAddress;
	uint32_t dwControlCacheSizeInBytes;
	uint32_t dwControlCacheCount;
};

#define HPI_HIF_PACK_ADAPTER_INFO(adapter, versionMajor, versionMinor) \
		((adapter << 16) | (versionMajor << 8) | versionMinor)
#define HPI_HIF_ADAPTER_INFO_EXTRACT_ADAPTER(adapterinfo) \
		((adapterinfo >> 16) & 0xffff)
#define HPI_HIF_ADAPTER_INFO_EXTRACT_HWVERSION_MAJOR(adapterinfo) \
		((adapterinfo >> 8) & 0xff)
#define HPI_HIF_ADAPTER_INFO_EXTRACT_HWVERSION_MINOR(adapterinfo) \
		(adapterinfo & 0xff)

/* Command/status exchanged between host and DSP */
#define HPI_HIF_IDLE		0
#define HPI_HIF_SEND_MSG	1
#define HPI_HIF_GET_RESP	2
#define HPI_HIF_DATA_MASK	0x10
#define HPI_HIF_SEND_DATA	0x13
#define HPI_HIF_GET_DATA	0x14
#define HPI_HIF_SEND_DONE	5
#define HPI_HIF_RESET		9

#endif				/* _HPI6000_H_ */
