## linux/alsa/Makefile.extra
##
##    AudioScience ALSA driver
##    Copyright (C) 1997-2017  AudioScience Inc. <support@audioscience.com>
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of version 2 of the GNU General Public License as
##    published by the Free Software Foundation;
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##

.DEFAULT_GOAL := all
abs-thisdir := $(realpath $(dir $(lastword $(MAKEFILE_LIST))))

-include build_overrides.mk
# hpi_version.mk must exist
include hpi_version.mk
# Include dist file lists
include distfiles.mk
# Include common firmware file lists. Must exist when not in staging.
include firmware/distfiles.mk

precious-files = build_overrides.mk
precious-files += $(all-dist-files)

all: setup build

setup: $(src-dist-files)

dkms-build: $(all-dist-files)
	sudo -A dkms build .

dkms-install: $(all-dist-files)
	sudo -A dkms install .

dkms-remove: $(all-dist-files)
	-sudo -A dkms remove snd-asihpi/$(hpi-repo-version-string) --all

dkms-rpm: $(all-dist-files)
	# Remove all ASI drivers tracked by DKMS
	-dkms status | awk -F',' '{print $$1,$$2}' | grep "snd-asihpi" | uniq | xargs -r sh -c 'dkms remove $$0/$$1 --all'
	sudo -A dkms add .
	sudo -A dkms mkrpm snd-asihpi/$(hpi-repo-version-string) --source-only

build: $(build-files)
	make -C $(shell sh ./kmod_config.sh) M=$(abs-thisdir)

install: build $(all-dist-files)
	make -C $(shell sh ./kmod_config.sh) M=$(abs-thisdir) modules_install
	install -d /etc/depmod.d
	echo 'override snd-asihpi * extra' > /etc/depmod.d/snd-asihpi.conf
	make -C firmware install
	depmod -a

clean distclean:
	rm -rf $(filter-out $(precious-files),$(wildcard *))

.PHONY: all setup build install uninstall dkms-install dkms-remove dist distclean firmware
