# HPK source package content and instructions

Please consider installing our software using our [Ubuntu PPA](https://launchpad.net/~audioscience/+archive/ubuntu/release) (or RPM builds once available) instead of compiling and installing manually using this source package archive. For instructions please see our website's [linux driver page](http://www.audioscience.com/internet/download/linux_drivers.htm).

Installing using your distribution packaging system eases management and update of drivers and libraries alike.

## Drivers

Two types of driver are included in this source package release: an ALSA+HPI driver and an HPI driver. We recommend installing the ALSA+HPI driver because it supports ALSA applications as well as HPI applications. The two drivers cannot be installed at the same time.

### Required tools

In order to build drivers, libraries and utilities on Ubuntu install the required tools using the following commands:

``` sh
> sudo apt-get install -y git build-essential dkms p7zip-full linux-headers-$(uname -r)
```

In order to build .deb packages run also the following commands:

``` sh
> sudo apt-get install -y devscripts fakeroot debhelper pbuilder debian-archive-keyring ubuntu-dev-tools
```

### Installing by creating RPMs (recommended for CentOS and Fedora)

First install `rpmbuild` if it's not already on your system:

``` sh
> sudo yum install rpm-build
> sudo yum install redhat-rpm-config
```

Then create RPMs for each required driver as follows.

##### ALSA

``` sh
> sudo make -C alsa-drv dkms-rpm
```

##### HPI

``` sh
> sudo make -C hpi-drv dkms-rpm
```

RPMs for HPI libraries, development headers, test applications and python modules are created by running:

``` sh
> make -C rpm-meta rpm-build
```

Install created RPMs using the `rpm` utility:

``` sh
> sudo rpm -i path-to-rpm-file
```

### Installing using DKMS

When using _DKMS_ to build and install drivers it must be installed on your system before attempting to install a driver.

#### Installing DKMS on Ubuntu and Debian
``` sh
> sudo apt-get install dkms
```

#### Installing DKMS on CentOS7, RHEL 7
``` sh
> sudo rpm -Uvh https://dl.fedoraproject.org/pub/epel/epel-release-latest-7.noarch.rpm
> sudo yum -y install kernel-headers kernel-devel dkms
```

#### Installing DKMS on CentOS6, RHEL 6
``` sh
> sudo rpm -Uvh https://dl.fedoraproject.org/pub/epel/epel-release-latest-6.noarch.rpm
> sudo yum -y install kernel-headers kernel-devel dkms
```

#### Installing DKMS on Fedora 26,25,24,23,22
``` sh
> sudo yum -y install kernel-headers kernel-devel dkms
```

#### ALSA driver
The ALSA driver is installed and removed by running respectively ```sudo make -C alsa-drv dkms-install``` and ```sudo make -C alsa-drv dkms-remove``` from the root directory of the uncompressed source package. ```sudo``` is required because installing and removing the driver requires root privileges.

#### HPI driver
The ALSA driver is installed and removed by respectively running ```sudo make -C hpi-drv dkms-install``` and ```sudo make -C hpi-drv dkms-remove``` from the root directory of the uncompressed source package. ```sudo``` is required because installing and removing the driver requires root privileges.

## HPI library (manual compile/install, not recommended)
Build and install the HPI libraries (_libhpi_ and _libhpiudp_) by running the following commands from the root directory of the uncompressed source package.

``` sh
> make -C hpi-lib
> sudo make -C hpi-lib install
```

It is not necessary to install the HPI library in order to run example applications included in this package. See the next section for instructions.

## Test and example applications (manual compile/install, not recommended)
Build and install the HPI command line test applications by running the following commands from the root directory of the uncompressed source package.

``` sh
> make -C hpi-cli-apps              # build
> sudo make -C hpi-cli-apps install # install (optional, see below)
```

Command line applications can be run directly from their build directory without being installed (and without installing or updating HP libraries) by prefixing the executable with ```LD_LIBRARY_PATH=hpi-lib``` like so:

``` sh
> LD_LIBRARY_PATH=hpi-lib ./hpi-cli-apps/asihpitest
```

However, when not relying on the HPI library installed on the system the ```hpi-lib``` target must the built following the instruction in the _HPI library_ section above.

##### asihpiassert
A program to retrieve assert messages from all adapters. Leave it running in a terminal window to see asserts as other programs are running. It always shows one test assert message for each adapter installed.

##### asihpitune
Query and set the tuners on an ASI89xx tuner card. ```asihpitune -?``` gives list of options Eg: ```asihpitune -t2 -bF -f92300 -s``` will set tuner 2 to FM band, 92300kHz, read back settings and RF level.

##### asihpiplay and asihpirec
Commandline player/recorder using HPI

## Creating debian packages

Make sure all the required tools listed at the top of this file are installed before building Debian packages.

``` sh
> make -C deb pkgsrc-build # build Debian source pacakges
> make -C deb pkgbin-build # build Debian source and binary packages (.deb files)
```

Packages will be located inside the $HOME/pbuilder/[distro]-[arch]_result directory.
