/*

    Copyright (C) 1997-2017  AudioScience Inc. <support@audioscience.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of version 2 of the GNU General Public License as
    published by the Free Software Foundation;

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

*/

#undef TRACE_SYSTEM
#define TRACE_SYSTEM asihpi
#define TRACE_INCLUDE_FILE trace_asihpi

#if !defined(_TRACE_ASIHPI_H) || defined(TRACE_HEADER_MULTI_READ)
#define _TRACE_ASIHPI_H

#include <linux/tracepoint.h>

struct snd_card_asihpi_pcm;

TRACE_EVENT(asihpi_stream_trigger,

	TP_PROTO(struct snd_pcm_substream *substream, int cmd),

	TP_ARGS(substream, cmd),

	TP_STRUCT__entry(
		__field( unsigned int, card )
		__field( unsigned int, number )
		__field( unsigned int, stream )
		__field( int, cmd )
	),

	TP_fast_assign(
		__entry->card = (substream)->pcm->card->number;
		__entry->number = (substream)->number;
		__entry->stream = (substream)->stream;
		__entry->cmd = cmd;
	),

	TP_printk("pcmC%dD0%c/sub%d: %d",
		  __entry->card,
		  __entry->stream == SNDRV_PCM_STREAM_PLAYBACK ? 'p' : 'c',
		  __entry->number,
		  __entry->cmd
		  )
);

TRACE_EVENT(asihpi_stream_state,

	TP_PROTO(struct snd_pcm_substream *substream,
	         struct snd_card_asihpi_pcm *ds,
	         struct hpi_stream_info *hsi),

	TP_ARGS(substream, ds, hsi),

	TP_STRUCT__entry(
		__field( unsigned int, card )
		__field( unsigned int, number )
		__field( unsigned int, stream )
		__field( int, pcm_buf_elapsed_dma_ofs )
		__field( int, pcm_buf_dma_ofs )
		__field( int, bytes_avail )
		__field( int, on_card_bytes )
		__field( int, samples_transferred )
		__field( int, hpi_stream_state )
	),

	TP_fast_assign(
		__entry->card = (substream)->pcm->card->number;
		__entry->number = (substream)->number;
		__entry->stream = (substream)->stream;
		__entry->pcm_buf_elapsed_dma_ofs = bytes_to_frames(substream->runtime, (ds)->pcm_buf_elapsed_dma_ofs);
		__entry->pcm_buf_dma_ofs = bytes_to_frames(substream->runtime, (ds)->pcm_buf_dma_ofs);
		__entry->bytes_avail = bytes_to_frames(substream->runtime, (hsi)->bytes_avail);
		__entry->on_card_bytes = bytes_to_frames(substream->runtime, (hsi)->on_card_bytes);
		__entry->samples_transferred = (hsi)->samples_transferred;
		__entry->hpi_stream_state = (hsi)->state;
	),

	TP_printk("pcmC%dD0%c/sub%d: hpi %d, elapsed %d, dma %d, avail %d, fifo %d, xfer %d",
		  __entry->card,
		  __entry->stream == SNDRV_PCM_STREAM_PLAYBACK ? 'p' : 'c',
		  __entry->number,
		  __entry->hpi_stream_state,
		  __entry->pcm_buf_elapsed_dma_ofs,
		  __entry->pcm_buf_dma_ofs,
		  __entry->bytes_avail,
		  __entry->on_card_bytes,
		  __entry->samples_transferred
		  )
);

TRACE_EVENT(asihpi_stream_xfer,

	TP_PROTO(struct snd_pcm_substream *substream, int xfer),

	TP_ARGS(substream, xfer),

	TP_STRUCT__entry(
		__field( unsigned int, card )
		__field( unsigned int, number )
		__field( unsigned int, stream )
		__field( int, xfer )
	),

	TP_fast_assign(
		__entry->card = (substream)->pcm->card->number;
		__entry->number = (substream)->number;
		__entry->stream = (substream)->stream;
		__entry->xfer = bytes_to_frames((substream)->runtime, xfer);
	),

	TP_printk("pcmC%dD0%c/sub%d : %d",
		  __entry->card,
		  __entry->stream == SNDRV_PCM_STREAM_PLAYBACK ? 'p' : 'c',
		  __entry->number,
		  __entry->xfer
		  )
);

TRACE_EVENT(asihpi_buffer_state,

	TP_PROTO(struct snd_pcm_substream *substream, struct hpi_hostbuffer_status *hhs),

	TP_ARGS(substream, hhs),

	TP_STRUCT__entry(
		__field( int, id )
		__field( unsigned int, size )
		__field( unsigned int, dsp_index )
		__field( unsigned int, host_index )
		__field( unsigned int, on_card_frames )
		__field( unsigned int, samples_transferred )
	),

	TP_fast_assign(
		__entry->id = substream->number +substream->stream * 0x100;
		__entry->size = bytes_to_frames(substream->runtime, (hhs)->dwSizeInBytes);
		__entry->dsp_index = bytes_to_frames(substream->runtime, (hhs)->dwDspIndex % (hhs)->dwSizeInBytes);
		__entry->host_index = bytes_to_frames(substream->runtime, (hhs)->dwHostIndex % (hhs)->dwSizeInBytes);
		__entry->on_card_frames = bytes_to_frames(substream->runtime, (hhs)->dwAuxiliaryDataAvailable);
		__entry->samples_transferred = (hhs)->dwSamplesProcessed;
	),

	TP_printk("HPI stream[%x]: size %d, dsp %d, host %d, fifo %d, xfer %d",
		__entry->id,
		__entry->size,
		__entry->dsp_index,
		__entry->host_index,
		__entry->on_card_frames,
		__entry->samples_transferred
	)
);

#endif /* _TRACE_ASIHPI_H */

/* This part must be outside protection */
#undef TRACE_INCLUDE_PATH
#define TRACE_INCLUDE_PATH .
#include <trace/define_trace.h>
