#!/bin/sh
# DKMS post-install script

PACKAGE_VERSION="4.20.36-g76c09bc"
PACKAGE_NAME="snd-asihpi"

echo "Current working directory: ${PWD}"
# Install firmware
make -C firmware install
# Override modules distributed with the kernel
echo 'override snd-asihpi * extra' > /etc/depmod.d/snd-asihpi.conf
echo 'override asihpi * extra' > /etc/depmod.d/asihpi.conf
# Install udev asihpi.rules if present
test -f asihpi.rules && install -D -m 0644 asihpi.rules /etc/udev/rules.d/45-asihpi.rules

# Reload driver when new one is installed

if [ $(uname -r) != $kernelver ] ; then
  # don't try to reload module when not installing for
  # current kernel
  exit 0
fi

if (lsmod | grep 'asihpi' -q) ; then
  modnames=$(lsmod | awk '/^asihpi|^snd_asihpi/ {print $1}')
  for modname in $modnames ; do
      echo "Unload $modname"
      rmmod $modname || {
		  echo "Failed - module still in use?"
		  exit 1
	  }
  done
fi

# Only get here if all loaded modules can be unloaded
# Need to depmod so new module is used by modprobe
depmod -a
modprobe -v ${PACKAGE_NAME} && echo "OK" || echo "Failed"
