/******************************************************************************
$Header: /Repository/drv/linux/test/asihpicn.c,v 1.4 2006/11/30 03:16:44 as-ewb Exp $
 
  Test Hardware Programming Interface (HPI) using HPI functions
 
  Usage: asihpitest --help
 
note to cleanup this file, use "astyle --style=linux -s4 asihpitest.c"
******************************************************************************/

#define SECONDS (1000/POLL_INTERVAL)
#define MINUTES (60*SECONDS)

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <getopt.h>
#include <hpi.h>
#include <hpidebug.h>

#define verbose_printf if (verbose) printf

typedef struct
{
    HW16            wControlType;           // HPI_CONTROL_METER, _VOLUME etc
    HW16            wSrcNodeType;
    HW16            wSrcNodeIndex;
    HW16            wDstNodeType;
    HW16            wDstNodeIndex;
}
hpi_control_t;

HPI_HSUBSYS *hSubSys;   // handle to audio subsystem

// local protos
void HandleError( HW16 wHE );

// global
#define BLOCK_SIZE 32768L //30720L //6144 //12288 //16384 //19200 //9600
HW8     abBuffer[BLOCK_SIZE];
short haveFiles=0;

/* Option variables */
HW32 hmi_address=1;
HW32 hmi_size=4;
HW32 do_write=0;
int write_value=0;
int wAdapterIndex=0;
int verbose=0;

static struct option long_options[] =
    {
        {"adapter" , required_argument, 0, 'a'
        },
        {"mi-address",required_argument,0,'m'},
		{"mi-size",required_argument,0,'s'},
        {"write-dec"       , required_argument ,0,'d'},
        {"write-hex"       , required_argument ,0,'x'},
		{"verbose", no_argument,0,'v'},
        {"help"       , no_argument,0,'h'},
        {0, 0, 0, 0}
    };

const char* short_options="a:d:m:s:vx:h?";

const char* option_help[]=
    {
        "<adapter number> to test.",
	"<addr> hex HMI address.",
	"<count> HMI bytes to get",
        "<decimal value> Write a value",
        "<hex value> Write a value",
	"Verbose mode",
        "Show this text."
    };
void help(void)
{
    int i=0;
	printf("\nASIHPICN - Cobranet HMI access");
    printf("\nUsage - asihpicn [options]\n");
    while (long_options[i].name != 0) {
        printf("--%s -%c %s\n",
               long_options[i].name,
               (char)(long_options[i].val),
               option_help[i]);
        i++;
    }
    exit(0);
}

void parse_options(int argc, char *argv[])
{
    int c;
    /*********** Parse the command line options ***************/
    while (1) {
      // int this_option_optind = optind ? optind : 1;
        int option_index = 0;

        c = getopt_long (argc, argv, short_options,
                         long_options, &option_index);
        if (c == -1)
            break;

        switch (c) {
        case 0:
            printf ("option %s", long_options[option_index].name);
            if (optarg)
                printf (" with arg %s", optarg);
            printf ("\n");
            break;
        case 'a':
            wAdapterIndex=atoi(optarg);
            break;
        case 'm':
			hmi_address=strtoul(optarg,(char **)NULL ,16);
            break;
        case 's':
            hmi_size=atoi(optarg);
            break;
		case 'v':
			verbose=1;
			break;
        case 'x':
			write_value=strtoul(optarg,(char **)NULL ,16);
			do_write=1;
            break;
        case 'd':
			write_value=strtoul(optarg,(char **)NULL ,10);
			do_write=1;
            break;
         case '?':
        case 'h':
            help();
            break;

        default:
            printf ("?? getopt returned character code 0%o ??\n", c);
        }
    }

    if (optind < argc) {
        // printf ("non-option ARGV-elements: ");
    }

}


/************************************** MAIN ***********************/
int main(int argc, char *argv[])
{
    HW32        wHE=0;  // HPI error
    HW32        dwVersion=0;
    HW16        wNumAdapters=0;
    HW16        awAdapterList[20];
    HW16        wListLength=20;
    HW16	wVersion;
    HW32	dwSerialNumber;
    HW16	wType;
    HW16	wNumOutStreams;
    HW16	wNumInStreams;


    HPI_HMIXER    hMixer=0;
    HPI_HCONTROL hControl;

    HW32  i=0;

    long testcount=0;
	
    parse_options(argc,argv);

    verbose_printf("********************************************************************\n");
    verbose_printf("\n** Test HPI using Functions **\n");

    /////////////////////////////////////////////////////////////////////////////
    // open subsystem and find adapters
    verbose_printf("********************************************************************\n");
    verbose_printf("HPI_SubSysCreate\n");
    hSubSys=HPI_SubSysCreate();
    if (hSubSys==NULL) {
        printf("hSubSys==NULL\n");
        exit(1);
    }

    wHE = HPI_SubSysGetVersion( hSubSys, &dwVersion );
    HandleError( wHE );
    verbose_printf("HPI_SubSysGetVersion=%x\n", dwVersion );

    wHE = HPI_SubSysFindAdapters(
              hSubSys,
              &wNumAdapters,
              awAdapterList,
              wListLength
          );
    HandleError( wHE );
    verbose_printf("%li HPI_SubSysFindAdapters NumberAdapters=%d ",testcount++, wNumAdapters);
    for(i=0; i<4; i++)
        verbose_printf("%d=%X ", i, awAdapterList[i] );
    verbose_printf("\n");

    if (awAdapterList[wAdapterIndex] == 0) {
        verbose_printf("No adapter with index %d\n",wAdapterIndex);
        exit(1);
    }

    wHE = HPI_AdapterClose(
              hSubSys,
              wAdapterIndex
          );
    HandleError( wHE );
    verbose_printf("HPI_AdapterClose \n");

    ////////////////////////////////////////////////////////////////////////////
    // open 1st adapter
    wHE = HPI_AdapterOpen(
              hSubSys,
              wAdapterIndex
          );
    HandleError( wHE );
    verbose_printf("HPI_AdapterOpen \n");

    wHE = HPI_AdapterGetInfo(
              hSubSys,
              wAdapterIndex,
              &wNumOutStreams,
              &wNumInStreams,
              &wVersion,
              &dwSerialNumber,
              &wType
          );
    HandleError( wHE );
    verbose_printf("HPI_AdapterGetInfo\n");
    verbose_printf("Adapter ID=%4X Index=%d NumOutStreams=%d NumInStreams=%d S/N=%d\nHw Version %c%d DSP code version %03d\n",
           wType, wAdapterIndex,
           wNumOutStreams, wNumInStreams, dwSerialNumber,
           ((wVersion>>3)&0xf)+'A',    // Hw version major
           wVersion&0x7,               // Hw version minor
           ((wVersion>>13)*100)+((wVersion>>7)&0x3f)  // DSP code version
          );

    ////////////////////////////////////////////////////////////////////////////
    // open the mixer of this adapter
    wHE = HPI_MixerOpen(
              hSubSys,
              wAdapterIndex,
              &hMixer
          );
    verbose_printf("HPI_MixerOpen: handle=%X\n", hMixer);
    HandleError( wHE );


	verbose_printf("Get cobranet control\n");
    wHE = HPI_MixerGetControl(hSubSys, hMixer,
                              HPI_SOURCENODE_COBRANET, 0,HPI_DESTNODE_COBRANET,0, HPI_CONTROL_COBRANET,
                              &hControl);
    HandleError( wHE );

    if (!wHE) {

#define BUFSIZE 100
		char cnData[BUFSIZE];
		HW32 byteCount;
		int i;
		
		if (hmi_size > BUFSIZE) hmi_size=BUFSIZE;
		
		memset(cnData,0,BUFSIZE);

		
		if (do_write) {

			printf("Write %#x to %#X\n",write_value,hmi_address);
			*((HW32 *)&cnData[0])=write_value;

			wHE = HPI_Cobranet_HmiWrite(
				hSubSys,
                hControl,
                hmi_address,
                hmi_size,
                (HW8 *)&cnData
                );

        HandleError( wHE );

		}


		verbose_printf("Read a value from %#X\n",hmi_address);
        wHE = HPI_Cobranet_HmiRead(
				hSubSys,
                hControl,
                hmi_address,
                hmi_size,
                &byteCount,
                (HW8 *)&cnData
                );

        HandleError( wHE );

		printf("%d bytes.  ",byteCount);
		printf("Hex: %#X %#X ",*(int*)&cnData[0],*(int *)&cnData[4]);
		printf("Decimal: %u %u\n",*(int*)&cnData[0],*(int *)&cnData[4]);
		for (i=0; i< byteCount; i++) {
			printf("%02hhx ",cnData[i]);
		}
		printf("\n");

	
		{ 
			HW32 status=0, readable=0, writeable=0;
			wHE = HPI_Cobranet_HmiGetStatus(hSubSys,hControl,&status,&readable,&writeable);
			HandleError( wHE );
			printf("Cobranet status 0x%02X Readable=0x%04X Writeable=0x%04X\n",status,readable,writeable);
		}

    }

    wHE = HPI_MixerClose(
              hSubSys,
              hMixer );
    verbose_printf("\nHPI_MixerClose\n" );
    HandleError( wHE );

    wHE = HPI_AdapterClose(
              hSubSys,
              wAdapterIndex );
    verbose_printf("HPI_AdapterClose\n" );
    HandleError( wHE );

    wHE = HPI_AdapterClose(
              hSubSys,
              wAdapterIndex );

    HPI_SubSysFree(hSubSys);
    return 0;
}



/****************************** HandleError **********************/
int getch(void)
{
    return getchar();
}

void    HandleError( HW16 wHE )
{
    char szError[256];
    char nK=0;

    if(wHE) {
        HPI_GetErrorText( wHE, szError );
        printf("ERROR %d %s\n", wHE, szError);
        printf("press Enter to continue, (q,Enter) to exit...\n");
        nK = getch();
        if(nK=='q')
            exit(0);
    }
}


/*
$Log: asihpicn.c,v $
Revision 1.4  2006/11/30 03:16:44  as-ewb
correct help text

Revision 1.3  2006/10/20 01:50:15  as-ewb
enable -Wall and fix resulting warnings

Revision 1.2  2006/01/25 15:30:55  as-tfe
Merged.

Revision 1.1.4.1  2005/12/15 04:07:49  as-ewb
Dont print subsys handle

Revision 1.1  2005/02/20 23:35:18  as-ewb
EWB cobranet hmi test, was cobratest.c


*/
