/******************************************************************************
Copyright (C) 1997-2003 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed 
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

  Test Hardware Programming Interface (HPI) using HPI functions

  Usage: thpilinux <adapter number> <audio filenames, ...>
  With no parameters, opens adapter 0 and attempts to play file0.wav file1.wav file2.wav file3.wav
******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <hpi.h>
#include <time.h>

// local protos
void HandleError( HW16 wHE );

/************************************** MAIN ***********************/
int main(int argc, char *argv[])
{
    HW16        wHE=0;  // HPI error
    HW32        dwVersion=0;
    HPI_HSUBSYS *hSubSys;   // handle to audio subsystem
    HW16        wAdapterIndex=0;
    HW16        wNumAdapters=0;
    HW16        awAdapterList[HPI_MAX_ADAPTERS];
    HW16        wListLength=20;
    HW32    i=0;
    struct timespec req;
    struct tm thetm;
    time_t  thetime;
    char s[40];

    printf("********************************************************************\n");
    printf("**      Report HPI asserts                                        **\n");
    printf("**      Press ctrl-C  to exit                                     **\n");

    // open subsystem and find adapters
    printf("********************************************************************\n");
    printf("HPI_SubSysCreate\n");
    hSubSys=HPI_SubSysCreate();
    if (hSubSys==NULL)
	{
	    printf("hSubSys==NULL\n");
	    exit(1);
	}

    wHE = HPI_SubSysGetVersion( hSubSys, &dwVersion );
    HandleError( wHE );
    printf("HPI_SubSysGetVersion=%x\n", dwVersion );

    wHE = HPI_SubSysFindAdapters(
				 hSubSys,
				 &wNumAdapters,
				 awAdapterList,
				 wListLength
				 );
    HandleError( wHE );
    printf("HPI_SubSysFindAdapters NumberAdapters=%d ", wNumAdapters);
    for(i=0; i<HPI_MAX_ADAPTERS; i++) {
	if (awAdapterList[i]) {
	    printf("%d=%X ", i, awAdapterList[i] );

	    wHE=HPI_AdapterOpen(hSubSys,i);
	    HandleError(wHE);
	    
	    wHE = HPI_AdapterTestAssert( hSubSys,i, i+1 );
	    HandleError(wHE );
	}
    }
    printf("\n");

    if (argc > 1)  // generate some more asserts, but dont read them
	goto  THPIExit;

    req.tv_sec=0;
    req.tv_nsec=250*1000000; // 250ms delay

    while (1) {
	/* check for asserts	*/ 
	HW16  nMaxLoops;
	HW16  wAssertPresent;
	HW16  wDspNum;
	HW32	wLineNumber=0;
	char	szAssert[100]={"test\0"};

	for (wAdapterIndex=0; wAdapterIndex<HPI_MAX_ADAPTERS; wAdapterIndex++) {
	    if (awAdapterList[wAdapterIndex]==0)
		continue;
	    wAssertPresent=1;
	    nMaxLoops=20;
	    wHE=0;
	    // if adapter does not support asserts wHE returns an error
	    while (wAssertPresent && !wHE && nMaxLoops--)
		{
		    wHE = HPI_AdapterGetAssertEx(
						 hSubSys,
						 wAdapterIndex,
						 &wAssertPresent,
						 szAssert,
						 &wLineNumber,
						 &wDspNum);
		    // not all adapters handle asserts !
		    if( (wHE!=0) && (wHE!=HPI_ERROR_INVALID_FUNC) )
			HandleError( wHE );

		    if(wAssertPresent && !wHE)
			{
			    time(&thetime);
			    localtime_r(&thetime,&thetm);
			    strftime (s, 40,"%j %T",&thetm);

			    printf("%s Adap%1d DSP#%1d %s %d 0x%08X\n",s, wAdapterIndex, wDspNum,szAssert, wLineNumber, wLineNumber);
			}
		}
	}
	if (nanosleep(&req,0))
	    break;
    }


 THPIExit:
    printf("HPI_AdapterClose\n" );
    for(i=0; i<HPI_MAX_ADAPTERS; i++) {
	if (awAdapterList[i]) {
	    wHE=HPI_AdapterClose(hSubSys,i);
	    HandleError( wHE );
	}
    }

    HPI_SubSysFree(hSubSys);
    return 0;
}



/****************************** HandleError **********************/
void    HandleError( HW16 wHE )
{
    char szError[256];
    char nK=0;

    if(wHE)
	{
	    HPI_GetErrorText( wHE, szError );
	    printf("ERROR %d %s\n", wHE, szError);
	    printf("press a key, <!> to exit...\n");
	    nK = getchar();
	    if(nK=='!')
		exit(0);
	}
}


/*
*/
