#!/usr/bin/python
# $Header: /Repository/drv/hpi/python/hpiexample.py,v 1.8 2007/06/15 00:56:55 as-ewb Exp $
#
# Example use of python hpi bindings
# 

import sys,time
if 1:
	import hpi
	from hpi import *
else:
	# Alternatively, can import hpinet, and talk to a networked ASI2416
	import hpinet
	from hpinet import *

def hw32_to_int(hw32):
    if (hw32 > 0x7FFFFFFF):
        hw32=hw32-0x100000000
    return hw32

def int_to_hw32(an_int):
    if (an_int < 0) :
        an_int= 0x100000000 + an_int
    return an_int

def MuxDetails(h):
    e,cnode,cindex=HPI_Multiplexer_GetSource(h)
    print
    for i in range(0,64):
        e,node,index=HPI_Multiplexer_QuerySource(h,i)
        if (e != 0):
            return ''
        if ((cnode==node) & (cindex==index)):
            print '->',
        print i,hpiSourceDict[node],index
    return ''

def TunerDetails(h):
    print
    e,cband=HPI_Tuner_GetBand(h);
    for i in range(0,64):
        e,band=HPI_ControlQuery(h,HPI_TUNER_BAND,i,0)
        if (e != 0):
            return ''
        if cband==band:
            print '->',
        print i,hpiTunerBandDict[band],
	e,min=HPI_ControlQuery(h,HPI_TUNER_FREQ,0,band)
	e,max=HPI_ControlQuery(h,HPI_TUNER_FREQ,1,band)
	e,step=HPI_ControlQuery(h,HPI_TUNER_FREQ,2,band)
	print min,'to',max,'step',step
    return ''

def SampleClockDetails(h):
    print
    e,csource=HPI_SampleClock_GetSource(h)
    for i in range(0,64):
        e,source=HPI_ControlQuery(h,HPI_SAMPLECLOCK_SOURCE,i,0)
        if (e != 0):
            break
        if csource==source:
            print '->',
        print i,hpiSampleClockSourceDict[source]
    
    e,crate=HPI_SampleClock_GetSampleRate(h)
    for i in range(0,64):
        e,rate=HPI_ControlQuery(h,HPI_SAMPLECLOCK_SAMPLERATE,i,0)
        if (e != 0):
            break 
        if crate==rate:
            print '->',
        print rate,
    return ''

def VolumeDetails(h):
    gain=HPI_VolumeGetGain(h);
    e,min=HPI_ControlQuery(h,HPI_VOLUME_GAIN,0,0)
    e,max=HPI_ControlQuery(h,HPI_VOLUME_GAIN,1,0)
    e,step=HPI_ControlQuery(h,HPI_VOLUME_GAIN,2,0)
    min=hw32_to_int(min)/100.0
    max=max/100.0
    step=step/100.0
    print gain,min,'to',max,'step',step,
    return ''

def LevelDetails(h):
    gain=HPI_LevelGetGain(h);
    e,min=HPI_ControlQuery(h,HPI_LEVEL_GAIN,0,0)
    if not e:
        e,max=HPI_ControlQuery(h,HPI_LEVEL_GAIN,1,0)
        e,step=HPI_ControlQuery(h,HPI_LEVEL_GAIN,2,0)
        min=hw32_to_int(min)/100.0
        max=max/100.0
        step=step/100.0
        print gain,min,'to',max,'step',step,
        return ''
    else:
        return gain

CtrlGet={
HPI_CONTROL_VOLUME:VolumeDetails,
HPI_CONTROL_LEVEL:LevelDetails,
HPI_CONTROL_METER:HPI_MeterGetPeak,
HPI_CONTROL_MULTIPLEXER:MuxDetails,
HPI_CONTROL_SAMPLECLOCK:SampleClockDetails,
HPI_CONTROL_TUNER:TunerDetails

}

def HPI_cleanup():
    """Close HPI mixer, adapter and subsystem."""
    HPI_MixerClose(hx)
    HPI_AdapterClose(adapter)
    HPI_SubSysFree()


def EnumerateControls(hx):
    print "Enumerate controls"
    print "Control number handle type location setting"
    e=0
    ci=0
    while (e == 0):
        e,srctype,srcindex,desttype,destindex,ctrltype,ch=HPI_MixerGetControlByIndex(hx,ci)
        if (e): break
        try:
            print "control" , ci, ch,hpiControlDict[ctrltype],"on",
            if (srctype != 100):
                print hpiSourceDict[srctype],srcindex,
                if (desttype != 200):
                    print "to",
            if (desttype != 200):
                print hpiDestDict[desttype],destindex,
            if (CtrlGet.has_key(ctrltype)):
                print CtrlGet[ctrltype](ch)
            else:
                print
        except KeyError:
            print "Control" , ci,  "type" , ctrltype,
            print "src",srctype,srcindex,
            print "dst",desttype,destindex

        ci += 1

def TestVolume(hx):
    print "Test Volume control"
    e,hv=HPI_MixerGetControl(hx,HPI_SOURCENODE_LINEIN,0,HPI_DESTNODE_LINEOUT,0,HPI_CONTROL_VOLUME)
    if e:
	print "No Linein->Lineout volume"
	return

    print "Range",HPI_VolumeQueryRange(hv)
    print "Gain",HPI_VolumeGetGain(hv)
    print "Set to (-1000,-1000) err=",HPI_VolumeSetGain(hv,(-1000,-1000))
    print "Gain readback",HPI_VolumeGetGain(hv)
    print "Set to (0,0) err=",HPI_VolumeSetGain(hv,(0,0))
    print "Gain readback",HPI_VolumeGetGain(hv)
    v=(0,0)
    print "Autofade 0 to -10dB over 2 secs"
    print HPI_VolumeAutoFade(hv,(-1000,-1000),2000)
    loops = 0
    while ((v[0] > -1000) and (loops < 20)):
        time.sleep(0.2)
        v=  HPI_VolumeGetGain(hv)
        print v
        loops = loops+1
    print
    e=HPI_VolumeSetGain(hv,(0,0))
    return hv

def TestLevel(hx):
    print "Test Level control"
    e,hv=HPI_MixerGetControl(hx,0,0,HPI_DESTNODE_LINEOUT,0,HPI_CONTROL_LEVEL)
    if e:
        print 'No lineout0 level control'
	return 
    print "Gain",HPI_LevelGetGain(hv)
    print "Set to (0,0) err=",HPI_LevelSetGain(hv,(0,0))
    print "Gain readback",HPI_LevelGetGain(hv)
    print "Set to (1400,1400) err=",HPI_LevelSetGain(hv,(1400,1400))
    print "Gain readback",HPI_LevelGetGain(hv)

def TestAsync(adapter):
    print "Test Async event polling"
    e,ha=HPI_AsyncEventOpen(adapter)
    if e: return 0

    evt=HPI_ASYNC_EVENT()

    e,numevents=HPI_AsyncEventGetCount(ha)
    while not e and numevents:
        HPI_AsyncEventGet(ha,1,evt)
        print "Seq",evt.wSequence,"type",evt.wEventType,"state",evt.dwState
        e,numevents=HPI_AsyncEventGetCount(ha)

    HPI_AsyncEventClose(ha)
    print
    return ha

def TestTonedetect(hx):
    print "Test Tonedetect"
    e,htd=HPI_MixerGetControl(hx,HPI_SOURCENODE_LINEIN,0,0,0,HPI_CONTROL_TONEDETECTOR)
    HPI_ToneDetector_SetEnable(htd,HPI_SWITCH_ON)
    HPI_ToneDetector_SetEventEnable(htd,HPI_SWITCH_ON)

    print HPI_ToneDetector_GetEnable(htd)
    print "Threshold", HPI_ToneDetector_GetThreshold(htd)
    print "State",HPI_ToneDetector_GetState(htd)
    print "Freq0",HPI_ToneDetector_GetFrequency(htd,0)
    print "Freq1",HPI_ToneDetector_GetFrequency(htd,1)
    print "Freq2",HPI_ToneDetector_GetFrequency(htd,2)
    print
    return htd


def TestMeter(hx):
    print "Test Meter"
    print "GetPeak"
    e,hm=HPI_MixerGetControl(hx,HPI_SOURCENODE_LINEIN,0,0,0,HPI_CONTROL_METER)
    for i in range(10):
        print HPI_MeterGetPeak(hm)
        time.sleep(0.1)
    print

def TestSilence(hx):
    print "Test Silence detector"
    e,hs=HPI_MixerGetControl(hx,0,0,HPI_DESTNODE_LINEOUT,0,HPI_CONTROL_SILENCEDETECTOR)
    print "Get silence control ",e
    HPI_SilenceDetector_SetThreshold(hs,-6000)
    HPI_SilenceDetector_SetDelay(hs,100)
    HPI_SilenceDetector_SetEnable(hs,1)
    HPI_SilenceDetector_SetEventEnable(hs,1)

    print "Enable", HPI_SilenceDetector_GetEnable(hs)
    print "Events", HPI_SilenceDetector_GetEventEnable(hs)
    print "State",HPI_SilenceDetector_GetState(hs)
    print "Threshold",HPI_SilenceDetector_GetThreshold(hs)
    print "Delay",HPI_SilenceDetector_GetDelay(hs)
    print

    return hs


def TestAssert(adapter):
    HPI_AdapterTestAssert(adapter,1234)
    asserts = HPI_AdapterGetAssertEx(adapter)
    while (asserts[1]>0) :
        print asserts
        asserts = HPI_AdapterGetAssertEx(adapter)

def ShowProfile(hp,np):
    e,mips=HPI_ProfileGetUtilization(hp)
    print 'DSP Mips',mips/100
    for p in range(0,np-1):
        e,name=HPI_ProfileGetName(hp,p,16)
        e,a,b,c,d,e=HPI_ProfileGet(hp,p)
        if (b != 0):
            print p,name,a,b,c,d,e

def TestProfile(adapter):
    e,hp,np=HPI_ProfileOpenAll(adapter,0)
    pnames=[HPI_ProfileGetName(hp,p,16)[1] for p in range(0,np-1)]
    e=HPI_ProfileStartAll(hp)
    ShowProfile(hp,np)
    return hp,np

def ProfileLoop(hp,np,nl):
    for l in range(0,nl):
        ShowProfile(hp,np)
        time.sleep(1)

############################################################################
FindAdapters()
if (len(sys.argv)> 1) :
    adapter=int(sys.argv[1])
else :
    adapter=0

e=HPI_AdapterOpen(adapter)
if e:
	sys.exit("Error " + repr(e))

ai=HPI_AdapterGetInfo(adapter)
print "Adapter",adapter, "type " + hex(ai[5])
print "SW version %d.%d" % ( ((ai[3] >> 13)& 0x7), ((ai[3] >> 7) & 0x3F))
print "HW version" ,chr(ord('A')+((ai[3] >> 3)& 0xF)) , ((ai[3] >> 0) & 0x7)
print
e,hx=HPI_MixerOpen(adapter)
if e:
	sys.exit("Mixeropen Error " + repr(e))

if __name__ == '__main__':
    EnumerateControls(hx)
    #hv=TestVolume(hx)
    #TestLevel(hx)
    #TestAssert(adapter)
    #hp,np=TestProfile(adapter)
    #hm=TestMeter(hx)
    #htd=TestTonedetect(hx)
    #hs=TestSilence(hx)
    #ha=TestAsync(hx)
    HPI_cleanup()
