#!/usr/bin/python

import hpi,sys,time
from hpi import *
from sys import exit

CtrlGet={HPI_CONTROL_VOLUME:HPI_VolumeGetGain,
HPI_CONTROL_MULTIPLEXER:HPI_Multiplexer_GetSource,
HPI_CONTROL_LEVEL:HPI_LevelGetGain,
HPI_CONTROL_METER:HPI_MeterGetPeak,
HPI_CONTROL_SAMPLECLOCK:HPI_SampleClock_GetSampleRate
}

def MuxListSources(h):
	e,cnode,cindex=HPI_Multiplexer_GetSource(h)
	print
	for i in range(0,64):
		e,node,index=HPI_Multiplexer_QuerySource(h,i)
		if (e != 0):
			return ''
		if ((cnode==node) & (cindex==index)):
			print '->',
		print i,hpiSourceDict[node],index
	return ''

CtrlGet[HPI_CONTROL_MULTIPLEXER]=MuxListSources

def HPI_cleanup():
    """Close HPI mixer, adapter and subsystem."""
    HPI_MixerClose(hx)
    HPI_AdapterClose(adapter)
    HPI_SubSysFree()

def hw32_to_int(hw32):
    if (hw32 > 0x7FFFFFFF):
        hw32=hw32-0x100000000
    return hw32

def int_to_hw32(an_int):
    if (an_int < 0) :
        an_int= 0x100000000 + an_int
    return an_int

def EnumerateControls(hx):
    print "Enumerate controls"
    print "Control number handle type location setting"
    e=0
    ci=0
    while (e == 0):
        e,srctype,srcindex,desttype,destindex,ctrltype,ch=HPI_MixerGetControlByIndex(hx,ci)
        if (e): break
        try:
            print "Control" , ci, ch,hpiControlDict[ctrltype],"on",
            if (srctype != 100):
                print hpiSourceDict[srctype],srcindex,
                if (desttype != 200):
                    print "to",
            if (desttype != 200):
                print hpiDestDict[desttype],destindex,
            if (CtrlGet.has_key(ctrltype)):
                print CtrlGet[ctrltype](ch)
            else:
                print
        except KeyError:
            print "Control" , ci,  "type" , ctrltype,
            print "src",srctype,srcindex,
            print "dst",desttype,destindex

        ci += 1


#FindAdapters()
if (len(sys.argv)> 1) :
	adapter=int(sys.argv[1])
else :
	print """Usage: hpicmd.py <adapter index> "python command to evaluate"
	Environment for evaluation includes all hpi modules, EnumerateControls(), hx=mixer handle for adapter
	
	Example: 
	hpicmd.py 0 "HPI_MixerGetControl(hx,HPI_SOURCENODE_OSTREAM,0,0,0,HPI_CONTROL_VOLUME")
	[0,28714] # error=0, volume handle=28714
	hpicmd.py 0 "HPI_VolumeGetGain(28714)"
	"""
	sys.exit()
	
e=HPI_AdapterOpen(adapter)
if e:
	sys.exit("Error " + repr(e))
	
e,hx=HPI_MixerOpen(adapter)
if e:
	sys.exit("Mixeropen Error " + repr(e))

print eval(sys.argv[2])
