/******************************************************************************
Copyright (C) 1997-2003 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed 
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

HPI Operating System Specific macros for Linux

(C) Copyright AudioScience Inc. 1997-2003
******************************************************************************/
#define HPI_OS_DEFINED

#include <linux/ioctl.h>
#include <stdio.h>
#include <stdlib.h>

#define INLINE inline

#if __GNUC__ >= 3
#define DEPRECATED __attribute__((deprecated))
#endif

#define __pack__ __attribute__ ((packed))

/* //////////////////////////////////////////////////////////////////////// */
/* BASIC TYPES */
/* unsigned word types */

#define HFAR
#define HPI_HUGE
#define HPI_API

typedef unsigned char HW8;    /**< 8 bit word = byte */
typedef unsigned short HW16;
typedef unsigned int HW32;

struct sHPI_MESSAGE;
struct sHPI_RESPONSE;

struct hpi_ioctl_linux
{
  struct sHPI_MESSAGE *phm;
  struct sHPI_RESPONSE *phr;
};

#define HPI_IOCTL_LINUX _IOWR('H', 1, struct hpi_ioctl_linux)

//#define NO_HPIOS_FILE_OPS
typedef FILE *HpiOs_FILE;
#define NO_FILE NULL

#define HpiOs_fopen_rb(a,b,c) (*(b)=fopen(a,"rb"),(*(b)?0:HPI_ERROR_DSP_FILE_NOT_FOUND))
#define HpiOs_fseek fseek
#define HpiOs_fread fread
#define HpiOs_fclose fclose

#define HpiOs_MemAlloc malloc
#define HpiOs_MemFree free

#define NO_HPIOS_LOCKEDMEM_OPS

#ifndef HPI_INCLUDE_DEPRECATED
#define HPI_EXCLUDE_DEPRECATED
#endif


//#define HPIOS_DEBUG_PRINTF printf
#define HPIOS_DEBUG_PRINTF(args...) fprintf(stderr,##args)

// case insensitive strcmp()
#define stricmp strcasecmp

//#define HIDE_DEPRECATED
//#define HPI_WITHOUT_HPI_DATA

///////////////////////////////////////////////////////////////////////////
