/******************************************************************************
 $Header: /Repository/drv/hpi/hpinet.h,v 1.16 2007/08/30 01:11:29 as-ewb Exp $

 HPI NETWORK implementation

 (C) Copyright AudioScience Inc. 2005
*******************************************************************************/

#ifndef _HPINET_H_
#define _HPINET_H_

#include <hpi.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	HPI_ETHERNET_MAC_ADR	destMAC;
	HPI_ETHERNET_MAC_ADR	srcMAC;
	unsigned char ProtocolMS;
	unsigned char ProtocolLS;
	unsigned char ASIpktID;
	unsigned char ASIpktVersion;
} HPINET_HEADER;

typedef struct {
	unsigned char LenLS;
	unsigned char LenMS;
	unsigned char unused0;
	unsigned char unused1;
} HPINET_HEADER_SIZE_INFO;

typedef struct {
	HPINET_HEADER_SIZE_INFO size;
	HPINET_HEADER hdr;
} HPINET_HEADER_WITH_SIZE;

/** maximum payload of an ethernet packet, excluding header and CRC */
#define HPINET_ETHERNET_DATA_SIZE (1500)
#define HPINET_IP_HDR_SIZE (20)
#define HPINET_IP_DATA_SIZE (HPINET_ETHERNET_DATA_SIZE - HPINET_IP_HDR_SIZE)
#define HPINET_UDP_HDR_SIZE (8)
#define HPINET_UDP_DATA_SIZE (HPINET_IP_DATA_SIZE - HPINET_UDP_HDR_SIZE)
#define HPINET_ASI_HDR_SIZE (2)
#define HPINET_ASI_DATA_SIZE (HPINET_UDP_DATA_SIZE - HPINET_ASI_HDR_SIZE)


#define HPINET_MSG_SIZEOF_DATA (HPINET_ASI_DATA_SIZE - sizeof(HPI_MESSAGE))

typedef struct {
	HPI_MESSAGE msg;
	char data[HPINET_MSG_SIZEOF_DATA];
} HPI_MESSAGEX;


#define HPINET_RESP_SIZEOF_DATA (HPINET_ASI_DATA_SIZE - sizeof(HPI_RESPONSE) - 16 )
typedef struct {
	HPI_RESPONSE resp;
	char data[HPINET_RESP_SIZEOF_DATA];
} HPI_RESPONSEX;

typedef struct {
	HPINET_HEADER_WITH_SIZE hdr;
	HPI_RESPONSE HPIresp;
	char data[HPINET_RESP_SIZEOF_DATA];
} HPINET_RESP_WITH_SIZE;

#if (defined HPI_OS_WIN32_USER) || (defined HPI_OS_LINUX)
void HPI_MessageEx(HPI_MESSAGEX *phm, HPI_RESPONSEX *phr ,
		unsigned int timeout
);
#endif

/* Legacy structures for hpinet.c */
typedef struct {
       HPINET_HEADER   hdr;
       HPI_MESSAGE             HPImsg;
       char data[HPINET_MSG_SIZEOF_DATA];
} HPINET_MSG;

typedef struct {
       HPINET_HEADER   hdr;
       HPI_RESPONSE HPIresp;
       char data[HPINET_RESP_SIZEOF_DATA];
} HPINET_RESP;

#ifdef __cplusplus
}
#endif
#endif

//$Log: hpinet.h,v $
//Revision 1.16  2007/08/30 01:11:29  as-ewb
//add back legacy structs to allow hpinet.c to compile.
//Needed for legacy fwupdate2416 to update older firmware to
//UDP capable firmware.
//
//Revision 1.15  2007/08/22 13:53:43  as-age
//Add struct back in for ASI6416 compile.
//
//Revision 1.14  2007/08/13 15:36:22  as-age
//Had to add -16 fudge factor to HPINET_RESP_SIZEOF_DATA to get control values
//by array to work from ASI2416. Must be some faulty header math somewhere, but I can't
//see it.
//
//Revision 1.13  2007/08/10 13:29:58  as-age
//Remove unused structs. Redo data sizing defines.
//
//Revision 1.12  2007/08/10 13:02:30  as-age
//Reduce the size of the data arrays in MSG and RESP so that everything fits in a UDP
//packet.
//
//Revision 1.11  2007/06/20 23:35:56  as-ewb
//hpimessagex is available on linux
//
//Revision 1.10  2007/03/16 21:29:03  as-age
//Put typedef name for struct on same line as closing } to get rid of Lint warnings.
//
//Revision 1.9  2007/01/19 19:48:59  as-age
//Change some define names.
//
//Revision 1.8  2006/11/30 01:00:58  as-ewb
//include hpi.h, this file depends on it
//
//Revision 1.7  2006/01/25 15:59:07  as-tfe
//Merged.
//
//Revision 1.2.4.3  2006/01/04 22:09:12  as-ewb
//update to match head 1.6
//
//Revision 1.2.4.2  2005/12/07 02:45:49  as-ewb
//Removed phSubsys from HPI_Message etc.
//
//Revision 1.2.4.1  2005/11/29 02:04:10  as-dxb
//Bringing the refactoring branch up to date with the cvs HEAD:
//copied hpinet.c and hpinet.h from HEAD
//
//Revision 1.4  2005/10/19 02:08:56  as-ewb
//ewb add extern "C" bracketing for C++
//
//Revision 1.3  2005/10/13 21:26:46  as-ewb
//Tweak ETHERNET_MAX_DATA_BYTES to account for ASI ID. Enforce a multiple of 4 bytes.
//
//Revision 1.2  2005/08/04 13:44:16  as-age
//AGE - tweaks to make use of structures on the DSP side of things.
//
//Revision 1.1  2005/08/04 03:27:12  as-ewb
//ewb definitions for hpinet.c (maybe goes to hpi.h eventually?)
//New defs for extended message and response structures.
//
