#ifndef _FWUPDATE_H_
#define  _FWUPDATE_H_

#include <hpi.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void progress_callback(char * state, u_int percent);

enum eHpiFirmwareId {HPI_FW_UPDATE=1, HPI_FW_FACTORY=2, HPI_FW_BOOTLOADER=3};

HPI_ERR HPI_FileFirmwareGetInfo(const char * fwpath, unsigned int * adapter,
                  unsigned int *version, unsigned int *checksum, unsigned int *length);

HPI_ERR HPI_AdapterFirmwareDownload(HW16 wAdapterIndex, enum eHpiFirmwareId ft,
                           const char *fwpath, progress_callback pc);

HPI_ERR HPI_AdapterFirmwareGetInfo(HW16 adapterIndex, enum eHpiFirmwareId fwid,
                  unsigned int *version, unsigned int *checksum, unsigned int *length);

HPI_ERR HPI_AdapterRestart(HW16 adapterIndex);

#ifdef __cplusplus
}
#endif
#endif
