/**
Copyright (C) 1997-2003 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed 
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )
*/

typedef struct {
	HPI_PCI Pci;        // PCI info - bus#,dev#,address etc
	HW16    wAdapterType;   // ASI6701 etc
	HW16    wIndex;     //
	HW16    wOpen;      // =1 when adapter open
	HW16    wMixerOpen;

#ifdef HPI_LOCKING
	HPIOS_SPINLOCK dspLock;
#endif

	HW16    wDspCrashed;
	HW16    wHasControlCache;
	void    *priv;
} HPI_ADAPTER_OBJ;

typedef struct {
#ifdef HPI_ALIST_LOCKING
	HPIOS_SPINLOCK aListLock;
#endif
	HPI_ADAPTER_OBJ adapter[HPI_MAX_ADAPTERS];
	HW16 gwNumAdapters; // total number of adapters created in this HPI
} HPI_ADAPTERS_LIST;


HPI_ADAPTER_OBJ* FindAdapter(HW16 wAdapterIndex);
void WipeAdapterList(void);
void SubSysGetAdapters(HPI_RESPONSE *phr);
HPI_ERR AddAdapter(HPI_ADAPTER_OBJ *pao);
void DeleteAdapter(HPI_ADAPTER_OBJ *pao);

short CheckControlCache( volatile tHPIControlCacheSingle *pC, HPI_MESSAGE *phm, HPI_RESPONSE *phr);
void SyncControlCache( volatile tHPIControlCacheSingle *pC, HPI_MESSAGE *phm, HPI_RESPONSE *phr);
HW16 HpiValidateResponse( HPI_MESSAGE *phm, HPI_RESPONSE *phr);


/*
*/
