/* $Header: /Repository/drv/hpi/hpi.i,v 1.19.2.3 2007/12/05 23:33:58 as-ewb Exp $
  SWIG interface file for asx C library
*/

%{
#define HPI_WITHOUT_HPI_DATA
#include "hpi.h"
#include "hpirds.h"

// Work around the unbounded array return.
// Hpinet MUST call FindAdapters to get the adapter list!
HW16 FindAdapters()
{
	HW16 numAdapters;
	HW16 adapterList[16];
	HW16 err;
	HPI_HSUBSYS temp;
	err=HPI_SubSysFindAdapters(&temp,&numAdapters,adapterList,16);

	return numAdapters;
}

HW16 HPI_OutStreamWriteData(HPI_HOSTREAM hOutStream,HPI_FORMAT f, char * outstreamdata, int outstreamdatabytes)
{
  HPI_HSUBSYS *phSubSys=NULL;

  return HPI_OutStreamWriteBuf(phSubSys,hOutStream,(unsigned char *)outstreamdata,outstreamdatabytes,&f);
}

HW16 HPI_InStreamReadData(HPI_HISTREAM hInStream, char * instreamdata, int *instreamdatabytes)
{
  HPI_HSUBSYS *phSubSys=NULL;
  HW16 e;

  e= HPI_InStreamReadBuf(phSubSys,hInStream,(unsigned char *)instreamdata, *instreamdatabytes );
  if (e)
    *instreamdatabytes=0;
  return e;
}
%}

// Implement sed -e "s/HPI_//" - all functions are in hpi namespace anyway.
// I.e. hpi.HPI_VolumeSetGain() becomes hpi.VolumeSetGain()
//%rename("%(command:hpistrip.bat )s", %$isfunction) "";

%typedef unsigned char HW8;
%typedef unsigned short HW16;
%typedef unsigned int HW32;

%include "typemaps.i"
%include "cstring.i"

/* meld of cstring_output_maxsize, and cstring_output_withsize
   return binary data of exact size passed in
*/
#ifdef SWIGPYTHON
%typemap(in,fragment=SWIG_As_frag(unsigned long)) (char * pbReadBuf, int dwBytesToRead) {
  $2 = ($2_ltype) SWIG_As(unsigned long)($input);
  if (SWIG_arg_fail($argnum)) SWIG_fail;
  $1 = SWIG_new_array($2+1, $*1_ltype);
}
#endif

%typemap(argout) (char * pbReadBuf, int dwBytesToRead) {
  $result = t_output_helper($result,SWIG_FromCharArray($1,$2));
  SWIG_delete_array($1);
}

#ifdef SWIGPYTHON
%init %{
  /* Calling this opens a file handle for the hpi ioctl */
  HPI_SubSysCreate();
%}

//%feature("autodoc",1);

%typemap(in) short anStopGain0_01dB[2] (short temp[2]),	short anGain0_01dB[2] (short temp[2])
{
  int i;
  if (!PySequence_Check($input)) {
    PyErr_SetString(PyExc_ValueError,"Expected a sequence");
    return NULL;
  }
  if (PySequence_Length($input) != $1_dim0) {
    PyErr_SetString(PyExc_ValueError,"Size mismatch. Expected $1_dim0 elements");
    return NULL;
  }
  for (i = 0; i < 2; i++) {
    PyObject *o = PySequence_GetItem($input,i);
    if (PyNumber_Check(o)) {
      temp[i] = (short) PyInt_AsLong(o);
    } else {
      PyErr_SetString(PyExc_ValueError,"Sequence elements must be numbers");
      return NULL;
    }
  }
  $1 = temp;
}

%typemap(in,numinputs=0) short anGain0_01dB_out[2]($*1_ltype temp[2], int res = 0),
 short anPeak0_01dB_out[2] ($*1_ltype temp[2], int res = 0) {
   $1=&temp[0];
 }

%typemap(argout) short anGain0_01dB_out[2], short anPeak0_01dB_out[2] {
  int i;
  PyObject *dB_out = 0;
  dB_out = PyList_New($1_dim0);
  for (i = 0; i < $1_dim0; i++) {
    PyObject *o = PyInt_FromLong((long) $1[i]);
    PyList_SetItem(dB_out, i, o);
  }
  $result = SWIG_AppendOutput($result, dB_out);
}
#endif
#ifdef SWIGCSHARP
%typemap(in) HPI_RDS_DATA * {
	$1 = void *($input);
}
%typemap(out) HPI_RDS_DATA * {
	$result = void *($1);
}
/*
%typemap(in) short anGain0_01dB[2] {
	$1 = (short *)($input);
}
*/
#endif


#ifdef SWIGPYTHON
/* Map phSubSys parameter away in python interface
   It is still there in the HPI interface, see hpix.h for a way to remove it from there.
*/
%typemap(in,numinputs=0) HPI_HSUBSYS *phSubSys (HPI_HSUBSYS hSubSys, int res=0)
{
	$1=&hSubSys;
}
#endif


/* Pointer parameters are outputs */
%apply unsigned int *OUTPUT { unsigned int* }
%apply unsigned short *OUTPUT { unsigned short* }
%apply short *OUTPUT { short* }
%apply int *OUTPUT { int* }
%apply float *OUTPUT { float* }
#ifdef SWIGPYTHON
%apply ( char *STRING, int LENGTH ) { (char * outstreamdata, int outstreamdatabytes) };
%apply ( char *STRING, int LENGTH ) { (char * pbWriteBuf, int dwBytesToWrite) };
#endif

#ifdef SWIGPYTHON
%cstring_bounded_output(char *pszAssert, 16);
%cstring_bounded_output(char *pszErrorText, 256);
%cstring_chunk_output(char *pRdsData, 12);
#endif
%cstring_output_maxsize(char * szProfileName, HW16 nProfileNameLength);


%cstring_output_withsize(char * instreamdata,int *instreamdatabytes);
//%cstring_output_maxsize2(char * pbReadBuf, int dwBytesToRead);
//%cstring_output_exactsize(char * pbReadBuf, int dwBytesToRead);

%ignore _HPI_H_;
%ignore HPI_DriverOpen;
%ignore HPI_DriverClose;
%ignore HPI_OutStreamGetInfo;
%ignore HPI_InStreamGetInfo;
%ignore HPI_Tuner_GetVideoStatus;
%ignore HPI_ProfileGetIdleCount;
%ignore HPI_SubSysCreate;
%ignore HPI_RESOURCE;
%ignore HPI_PORTIO;
%ignore HPI_USB;
%ignore HPI_PCI;
//%ignore HPI_VERSION;
%ignore HPI_SubSysReadPort8;
%ignore HPI_SubSysWritePort8;
%ignore HPI_SubSysCreateAdapter;
%ignore HPI_SubSysDeleteAdapter;
%ignore HPI_Message;
%ignore HPI_InitMessage;
%ignore HPI_InitResponse;


#if 0
%typemap(out) HW16 {
	// Empty out typemap discards function return value
}

// convert HPI error return into Python exception
%exception {
	// Exception handler from hpi.i
	$action
	if (result) {
		PyErr_Format(PyExc_Exception,"HPI error %d",result);
		return NULL;
	}
}
#endif

//%exception HPI_FORMAT32 { }
//%noallowexception HPI_FORMAT;


%wrapper {
// %wrapper ends up before wrapped functions in asx_wrap.c
// end %wrapper
}


%runtime {
// %runtime appears after wrapped functions
// end %runtime
}

#ifdef SWIGPYTHON
%pythoncode %{
# %pythoncode
def HPI_cleanup(adapter):
    """Close HPI mixer, adapter and subsystem."""
    HPI_AdapterClose(adapter)
    HPI_SubSysFree()

def hw32_to_int(hw32):
    if (hw32 > 0x7FFFFFFF):
        hw32=hw32-0x100000000
    return hw32

def int_to_hw32(an_int):
    if (an_int < 0) :
        an_int= 0x100000000 + an_int
    return an_int

# Group some of the constants into dictionaries, get name from value
def hpiMakeDict(root):
    n=[x for x in dir(_hpi) if (x.startswith(root) and not (x.endswith('LAST_INDEX') or x.endswith('LAST') or x.endswith('SET') or x.endswith('QUERY'))) ]
    v=[eval('_hpi.' +s) for s in n]
    return dict(zip(v,n))

hpiErrorDict=hpiMakeDict('HPI_ERROR_')
hpiControlDict=hpiMakeDict('HPI_CONTROL_')
hpiSourceDict=hpiMakeDict('HPI_SOURCENODE')
hpiDestDict=hpiMakeDict('HPI_DESTNODE')
hpiTunerBandDict=hpiMakeDict('HPI_TUNER_BAND_')
# Watch out for HPI_SAMPLECLOCK_SOURCE_INDEX==HPI_SAMPLECLOCK_SOURCE_WORD==3,
hpiSampleClockSourceDict=hpiMakeDict('HPI_SAMPLECLOCK_SOURCE_')
hpiAdapterModeDict=hpiMakeDict('HPI_ADAPTER_MODE_')


class HpiError(Exception):
    def __init__(self, value):
         self.value = value
    def __str__(self):
         return repr(self.value)

# end %pythoncode
%}
#endif

#define HPI_API
#define HPI_WITHOUT_HPI_DATA
%include "hpi.h"
%include "hpirds.h"

#ifdef SWIGPYTHON
/* Generic setting of control attribute value */
HW16 HPI_ControlParamSet(
	 const HPI_HSUBSYS     *phSubSys,
	 const HPI_HCONTROL    hControlHandle,
	 const HW16            wAttrib,
	 const HW32            dwParam1=0,
	 const HW32            dwParam2=0
);

/* generic getting of control attribute value.
   Null pointers allowed for return values
*/
HW16 HPI_ControlParamGet(
	 const HPI_HSUBSYS     *phSubSys,
	 const HPI_HCONTROL    hControlHandle,
	 const HW16            wAttrib,
	 HW32                  dwParam1=0,
	 HW32                  dwParam2=0,
	 HW32        		   *pdwParam1,
	 HW32                  *pdwParam2
);

HW16 FindAdapters(void);
HW16 HPI_InStreamReadData(HPI_HISTREAM hInStream, char * instreamdata,int *instreamdatabytes);
HW16 HPI_OutStreamWriteData(HPI_HOSTREAM hOutStream,HPI_FORMAT f, char * outstreamdata, int outstreamdatabytes);

#endif

/*
$Log: hpi.i,v $
Revision 1.19.2.3  2007/12/05 23:33:58  as-ewb
fix typo

Revision 1.19.2.2  2007/12/05 23:03:21  as-ewb
update hpiMakeDict to (simple version of) HEAD

Revision 1.19.2.1  2007/10/19 18:57:17  as-age
update meters and volume to return [error [reading]]

Revision 1.19  2007/09/11 01:20:59  as-ewb
add adapter mode dict

Revision 1.18  2007/09/06 04:29:14  as-ewb
hpiMakeDict adapts to module name (for hpiudp)

Revision 1.17  2007/06/27 18:50:26  as-age
Add python conditional sections.

Revision 1.16  2007/06/14 03:56:13  as-ewb
add sampleclock source dict

Revision 1.15  2007/05/22 22:55:55  as-ewb
fix dictionary generator

Revision 1.14  2007/03/27 19:43:56  as-age
Increase size of pRdsData so that it can contain error codes.

Revision 1.13  2007/03/22 04:00:34  as-ewb
add string typemap for pRdsData

Revision 1.12  2006/11/30 12:47:18  as-ewb
tweak for hpinet

Revision 1.11  2006/11/29 23:55:03  as-ewb
remove reference to HPI_DATA

Revision 1.10  2006/11/22 03:57:32  as-ewb
new typemap for InStreamReadBuf

Revision 1.9  2006/11/15 01:37:05  as-ewb
fix compiler warnings, add convenience dicts and lists

Revision 1.8  2006/10/17 21:45:48  as-ewb
replace use of HPI_DATA internals with HPI_DataCreate.
add some utility functions to python code

Revision 1.7  2006/08/09 03:53:38  as-ewb
string output map for HPI_GetErrorText string

Revision 1.6  2006/08/08 00:59:05  as-ewb
tweaks to use asihpi32.dll

Revision 1.5  2006/06/08 22:59:21  as-ewb
ignore some hpi internal functions

Revision 1.4  2006/03/07 00:51:41  as-ewb
add wrapper functions for stream data I/O.  Do subsys init on library load.

Revision 1.3  2006/02/08 20:14:57  as-ewb
typemap for profileGetName

Revision 1.2  2006/01/25 14:24:38  as-tfe
Adding files to main branch that were created in refactored branch.

Revision 1.1.2.4  2006/01/12 23:06:25  as-ewb
turn on autodoc

Revision 1.1.2.3  2006/01/10 07:28:21  as-ewb
Make input parameters of HPI_ControlParamSet/Get optional, default to 0

Revision 1.1.2.2  2005/12/15 01:20:27  as-ewb
Typemap for assert strings.  typemap to get rid of phsubsys from python interface.

Revision 1.1.2.1  2005/12/07 08:07:45  as-ewb
SWIG interface file for hpi


*/
