#!/usr/bin/python
""" Decode the header of dsp bin file """
import sys
import os
import re
import struct

def print_header(fname):
	f=open(fname,'rb')
	h=f.read(20)

	(s,t,a,v,c) = struct.unpack('I4sIII',h)
	if t != 'CODE':
		print fname,"not an ASI firmware file?"
		return
	vmaj=v/10000
	v=v-vmaj*10000
	vmin = v/100
	v = v - vmin*100

	print 'AX%x, version %d.%02d.%02d, size %d, checksum 0x%X' % (a,vmaj,vmin,v,s,c)
	f.close()

if __name__ == "__main__":
	if len(sys.argv) > 1:
		d=sys.argv[1]+'/'
	else:
		d='./'

	d = os.path.abspath(os.path.dirname(d))
	test = re.compile("dsp[0-9]*\.bin")
	files = filter(test.search, os.listdir(d))
	map(print_header,files)
