#!/usr/bin/python
# $Header: /home/eliot/asi/repo/cvsrepo/Repository/drv/hpi/python/hpivolumes.py,v 1.6 2010/11/05 21:29:58 as-ewb Exp $
#
# Example use of python hpi bindings

import sys
import audioscience.hpi as hpi
from sys import exit
from Tkinter import *
from ScrolledText import ScrolledText
from time import *
from audioscience.scrolled import Scrolledframe

def parseArgs():
    """Parse the commandline arguments"""
    from optparse import OptionParser, OptionGroup

    parser = OptionParser()
    parser.add_option('-a','--adapter',type='int',dest='adapter',
                      help='Adapter index. Default=%default', default=0)

    parser.add_option('-n','--node',type='int',dest='node',
                      help='Node type=%default', default=0)

    parser.add_option('-I','--interface-ip-address',type='string',dest='ipaddr',
                          help='Interface IP address.', default=None)

    return parser.parse_args()

opts,args = parseArgs()
hpi.setup(opts.adapter, opts.ipaddr)

sstate=('?','Stopped','Playing','Recording','Xrun')

hpi.NODE={100:'none',101:'OutStream',102:'LineinIn',103:'AesesbuIn',104:'Tuner',105:'Rf',106:'ClockSource',107:'Bitstream',108:'Mic',109:'Cobranet',
200:'none',201:'InStream',202:'LineOut',203:'AesebuOut',204:'Rf',205:'Speaker',206:'Cobranet'}

def AdapterInfoString(adapter):
  e,nos,nis,ver,serial,atype = hpi.Adapter_GetInfo(adapter)
  return "%d: ASI%x IS=%d OS=%d" % (adapter,atype, nis, nos)

class HpiVolume (Frame):

  def __init__(self, hmixer, node1, index1, node2=0, index2=0, master=None):
    self.hx = hmixer

    if (node2) :
        e,self.hv=hpi.Mixer_GetControl(self.hx,node1,index1,node2,index2,hpi.CONTROL_VOLUME)
    elif (node1 < 200):
        e,self.hv=hpi.Mixer_GetControl(self.hx,node1,index1,0,0,hpi.CONTROL_VOLUME)
    else:
        e,self.hv=hpi.Mixer_GetControl(self.hx,0,0,node1,index1,hpi.CONTROL_VOLUME)

    #print hpi.SourceDict[node1],index1,hpi.DestDict[node2],index2
    if e:
        raise LookupError('Volume on %s %d %s %d not found' % (hpi.SourceDict[node1],index1,hpi.DestDict[node2],index2))

    Frame.__init__(self, master)
    self.pack(side='left')

    self.left=IntVar()
    self.right=IntVar()
    e,r=hpi.Volume_GetGain(self.hv)

    self.left.set(r[0]/100)
    self.right.set(r[1]/100)

    self.createWidgets(node1, index1, node2, index2)

  def createWidgets(self,node1,index1,node2,index2):
      self.label =Label(self,text=hpi.NODE[node1]+str(index1))
      self.label.pack()
      if node2:
        self.label2 =Label(self,text=hpi.NODE[node2]+str(index2))
        self.label2.pack()

      self.ml=Scale(self)
      self.ml['to']=-100
      self.ml["variable"]=self.left
#      self.left.trace_variable("w",self.onLeft)
      self.ml.pack(side='left')

      self.mr=Scale(self)
      self.mr['to']=-100
      self.mr["variable"]=self.right
#      self.right.trace_variable("w",self.onRight)
      self.mr.pack(side='left')
      # registering callback
      self.listenID = self.after(100, self.updateVol)

  def updateVol(self):
      self.listenID = self.after(200, self.updateVol)
      hpi.Volume_SetGain(self.hv, (self.left.get()*100, self.right.get()*100))

  def onLeft(self,name,index,mode):
    print 'Left',name,index,mode,self.left.get()

  def onRight(self,name,index,mode):
    print 'Right',name,index,mode,self.right.get()


class OutstreamVolumes(Frame):
  def __init__(self, hmixer, index, master=None):
    Frame.__init__(self, master)
    self.pack(side='top')
    HpiVolume(hmixer, hpi.SOURCENODE_OSTREAM, index, 0, 0, master=self)
    for i in range(nis):
        try:
            HpiVolume(hmixer, hpi.SOURCENODE_OSTREAM, index, hpi.DESTNODE_LINEOUT, i, master=self)
        except LookupError:
            break

class LineoutVolumes(Frame):
  def __init__(self, hmixer, index, master=None):
    Frame.__init__(self, master)
    self.pack(side='top')
    for i in range(nos):
        try:
            HpiVolume(hmixer, hpi.SOURCENODE_OSTREAM, i, hpi.DESTNODE_LINEOUT, index, master=self)
        except LookupError:
            break
    for i in range(nis):
        try:
            HpiVolume(hmixer, hpi.SOURCENODE_LINEIN, i, hpi.DESTNODE_LINEOUT, index, master=self)
        except LookupError:
            break

if __name__ == "__main__":
    adapter = opts.adapter
    hpi.setup(opts.adapter)

    e = hpi.Adapter_Open(adapter)
    if e:
        sys.exit('HPI error %d' % e)

    e,nos,nis,ver,serial,atype = hpi.Adapter_GetInfo(adapter)

    e, hmixer = hpi.Mixer_Open(adapter)
    app = Tk()
    app.title("HPI Volume Controls")
    scrollframe=Scrolledframe(app,stretch=True)

    Label(scrollframe(), text=AdapterInfoString(adapter)).pack(anchor="nw")

    if len(sys.argv) > 2 and sys.argv[2]=='o':
      for i in range(nos):
        OutstreamVolumes(hmixer,i, master = scrollframe())
    else:
      for i in range(nos):
        LineoutVolumes(hmixer,i, master = scrollframe())

    scrollx=Scrollbar(app,orient="horizontal",command=scrollframe.xview)
    scrollx.grid(row=1,column=0,sticky="nwse")
    scrolly=Scrollbar(app,orient="vertical",command=scrollframe.yview)
    scrolly.grid(row=0,column=1,sticky="nwse")
    scrollframe["xscrollcommand"]=scrollx.set
    scrollframe["yscrollcommand"]=scrolly.set

    scrollframe.grid(row=0,column=0,sticky="nwse")
    #scrollframe.pack()

    app.columnconfigure(0,weight=1)
    app.rowconfigure(0,weight=1)
    app.geometry("800x600")
    app.mainloop()
############################################################################
